﻿using PpmsDataWebService.Models;
using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using System.Web.Http.Description;
using Microsoft.Web.Http;

namespace PpmsDataWebService.Controllers
{

    //[Authorize]
    [EnableQuery]
    [ApiVersion("1.0")]
    public class ProviderPrivilegesController : ODataController
    {
        [ODataRoute("ProviderPrivileges({Name})")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string Name)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderPrivilege =
                    context.ppms_providerprivilegeSet.FirstOrDefault(x => x.ppms_name.Equals(Name));
                if (ppmsProviderPrivilege != null)
                {
                    var ppmsProviderPrivilegesList = new List<ppms_providerprivilege> {ppmsProviderPrivilege};
                    var providerPrivileges = await ProviderPrivilegesMap.MapProviderPrivileges(ppmsProviderPrivilegesList, queryType, context);
                    return Request.CreateResponse(providerPrivileges);
                }
                var message = string.Format("Provider Privilege with Name: {0} not found", Name);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("ProviderPrivileges({Name})/Provider")]
        public async Task<HttpResponseMessage> GetProvider([FromODataUri] string Name)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderPrivilege =
                    context.ppms_providerprivilegeSet.FirstOrDefault(x => x.ppms_name.Equals(Name));
                if (ppmsProviderPrivilege != null)
                {
                    //Retrieve and Return the related Provider
                    var ppmsProvider =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderPrivilege.ppms_ProviderId.Id);
                    var ppmsProviderList = new List<Account> { ppmsProvider };
                    var provider =
                        await ProviderMap.MapProviders(ppmsProviderList, "None");
                    return Request.CreateResponse(provider);
                }
                var message = string.Format("Provider with Provider Privilege Name: {0} not found", Name);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("ProviderPrivileges({Name})/PrivilegeLocation")]
        public async Task<HttpResponseMessage> GetPrivilegeLocation([FromODataUri] string Name)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderPrivilege =
                    context.ppms_providerprivilegeSet.FirstOrDefault(x => x.ppms_name.Equals(Name));
                if (ppmsProviderPrivilege != null)
                {
                    //Retrieve and Return the related Priv Location
                    var ppmsCareSite =
                        context.ppms_caresiteSet.FirstOrDefault(
                            i => i.Id == ppmsProviderPrivilege.ppms_CareSite.Id);
                    var ppmsCareSiteList = new List<ppms_caresite> { ppmsCareSite };
                    var privilegeLocation =
                        await CareSiteMap.MapCareSites(ppmsCareSiteList, "None", context);
                    return Request.CreateResponse(privilegeLocation);
                }
                var message = string.Format("Privilege Location with Provider Privilege Name: {0} not found", Name);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("ProviderPrivileges")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Providers in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderPrivileges = context.ppms_providerprivilegeSet.Where(i => i.ppms_name != null && i.ppms_ProviderId !=null && i.ppms_CareSite != null).Take(50);
                var ppmsProviderPrivilegesList = ppmsProviderPrivileges.ToList();
                if (ppmsProviderPrivilegesList.Any())
                {
                    //Map Providers
                    var providerPrivileges = await ProviderPrivilegesMap.MapProviderPrivileges(ppmsProviderPrivilegesList, "None", context);
                    return Request.CreateResponse(providerPrivileges);
                }
                var message = "Provider Privileges Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }
    }
}